function [X_sub, y_sub, dataset_name] = dat_splice_sub(n_sub)
    temp = load('data/benchmarks.mat');
    
    scurr = rng; % get random number generator state
    
    rng(1); % set seed to 1
    
    X = temp.splice.x;
    y = temp.splice.t;
    
    n = size(X,1);
    my_perm = randperm(n);
    
    X = X(my_perm,:);
    y = y(my_perm,:);
    
    X_sub = X(1:n_sub,:);
    y_sub = y(1:n_sub,:);
    
    dataset_name = sprintf('splice%d',n_sub);
    
    rng(scurr);

end