function [X,y] = dat_extract(Dataset, TotalVars, CatVars, NumVars, TargetVar, MaxObservations, RNDSeed)
% [X,y] = dat_extract(Dataset, TotalVars, CatVars, NumVars, TargetVar)
% Dataset: Matlab 'Table'
% TotalVars: total number of variables
% CatVars: array with indices of the categorical variables
% NumVars: array with indices of the numerical variables (excluding target)
% TargetVar: index of the target variable (regression)
% MaxObservations: maximum number of observations (if larger, random
% subsample)
% RNDSeed: random seed for subsampling

assert(size(Dataset,2) == TotalVars);
assert(length(CatVars) + length(NumVars) + length(TargetVar) == TotalVars);

numlevels = nan(CatVars,1);

for i = 1:length(CatVars)
    
    mydummy = Dataset(:,CatVars(i));
    numlevels(i) = length(unique(table2array(mydummy)));
    
end

if (length(CatVars) > 0)
    vars_dummys = dummyvar(table2array(Dataset(:,CatVars)));
else
    vars_dummys = [];
end
vars_numeric = table2array(Dataset(:,NumVars));

X = [vars_dummys, vars_numeric];
y = table2array(Dataset(:,TargetVar));

assert(size(X,2) == (length(NumVars) + sum(numlevels)))

n = size(X,1);
if n > MaxObservations
    rng(RNDSeed);
    ids = randperm(n);
    ids_use = ids(1:MaxObservations);
    X = X(ids_use,:);
    y = y(ids_use,:);
end

end